<?php get_header(); ?>

<div id="main">
	
	<div id="content">
		<?php if (have_posts()) : ?>
		<?php $post = $posts[0]; ?>
		<?php if (is_category()) { ?><h2>Archive for '<?php echo single_cat_title(); ?>'</h2>
		<?php } elseif (is_day()) { ?><h2>Archive for <?php the_time('F jS, Y'); ?></h2>
		<?php } elseif (is_month()) { ?><h2>Archive for <?php the_time('F, Y'); ?></h2>
		<?php } elseif (is_year()) { ?><h2>Archive for the year <?php the_time('Y'); ?></h2>
		<?php } elseif (is_tag()) { ?><h2>Tag: <?php single_tag_title(''); ?></h2>
		<?php } elseif (is_search()) { ?><h2>Search results</h2>
		<?php } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?><h2>Archives</h2>
		<?php } ?>
		<?php while (have_posts()) : the_post(); ?>
			<div class="post" id="post-<?php the_ID(); ?>">
				<div class="postheader">
					<h2 class="posttitle"><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
					<div class="postmeta"><?php the_time('l, F jS, Y'); ?> | <?php the_category(', '); ?> | <?php comments_popup_link(__('No Comments'), __('1 Comment'), __('% Comments')); ?></div>
				</div>
				<div class="postcontent"><?php the_content(__('&rsaquo; Continue reading...')); ?></div>
				<?php the_tags('Tags: ', ', ', ''); ?>
			</div>
		<?php endwhile; ?>
		<div class="post">
			<?php next_posts_link('&laquo; Previous posts') ?> <?php previous_posts_link('Next posts &raquo;') ?>
			<a href="#main">Back to top</a>
		</div>
		<?php else : ?>
			<div class="post">
				<h2>Not found!</h2>
				<p><?php _e('Sorry, this page does not exist.'); ?></p>
				<?php include (TEMPLATEPATH . "/searchform.php"); ?>	
			</div>
		<?php endif; ?>
	</div>
	
	<?php get_sidebar(); ?>
	
</div>

<?php get_footer(); ?>