<?php
// Translations can be filed in the /lang/ directory
load_theme_textdomain( 'TravelPress', TEMPLATEPATH . '/lang' );	

require_once(TEMPLATEPATH . '/includes/sidebar-init.php');
require_once(TEMPLATEPATH . '/includes/custom-functions.php'); 
require_once(TEMPLATEPATH . '/includes/post-thumbnails.php'); 

require_once(TEMPLATEPATH . '/includes/theme-options.php');
// require_once(TEMPLATEPATH . '/includes/theme-comments.php');
require_once(TEMPLATEPATH . '/includes/theme-widgets.php');

require_once(TEMPLATEPATH . '/functions/theme_functions.php'); 
require_once(TEMPLATEPATH . '/functions/admin_functions.php');
require_once(TEMPLATEPATH . '/functions/shortcodes.php');

##################################################################
# Login and Register;
##################################################################
// display the register link in the header if enabled
function clpr_register( $before = '<li>', $after = '</li>', $echo = true ) {
	if ( ! is_user_logged_in() ) {
		if ( get_option('users_can_register') )			
			$link = $before . '<a href="' . site_url('wp-login.php?action=register', 'login') . '">' . __('Registrarse', 'appthemes') . '</a>' . $after;
		else
			$link = '';
	} else {	
		$link = $before . '<a href="' . site_url('wp-admin/index.php', 'dashboard') . '">' . __('Mi panel', 'appthemes') . '</a>' . $after;		
	}
	if ( $echo )
		echo apply_filters('register', $link);
	else
		return apply_filters('register', $link);
}
?>